#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//rotating flowers and shapesMod01.fsh   by   garabatospr  
//https://www.shadertoy.com/view/msjSRD
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.1415926535897932384626433832795
#define len 5.0

// Author: Elio Ramos (@garabatospr instagram, twitter) 

// color palette

const vec3 COLORS[]=vec3[](
	vec3(0.949,0.922,0.541),
    vec3(0.996,0.816,0.),
    vec3(0.988,0.518,0.0),
    vec3(0.929,0.212,0.102),
    vec3(0.886,0.941,0.953),
    vec3(0.702,0.863,0.878),
    vec3(0.267,0.392,0.631),
    vec3(0.125,0.188,0.318),
    vec3(1.,0.773,0.78),
    vec3(0.953,0.596,0.765),
    vec3(0.812,0.22,0.584),
    vec3(0.427,0.208,0.541),
    vec3(0.024,0.706,0.69),
    vec3(0.294,0.541,0.373)  
);


float Hash21(vec2 p) {
    p = fract(p*vec2(234.234, 435.145));
    p += dot(p, p+34.236767);
    return fract(p.x*p.y);
}

// get "random" color based on location 

vec3 getColor(vec2 id,float seed)
{
  return COLORS[int(14.*Hash21(id*seed))];
}

// standard 2d rotation matrix 

mat2 rotate2d(in float radians)
{
  float c = cos(radians);
  float s = sin(radians);
  return mat2(c, -s, s, c);
}

// distortion function 


vec2 distort(vec2 uv,float freq)
{
  float freq1 = 2.;
  float freq2 = 2.;

  float x = uv.x;
  float y = uv.y;

  return vec2(x + cos(freq1*y + freq*iTime)*0.1,y + cos(freq2*x + freq*iTime)*0.1);
}

// draw flowers with polar coordinates 

vec3 drawFlower(vec2 uv,vec2 offset,float rad,vec3 col,vec3 col1,vec3 col2)
{
   float n = floor(10.*Hash21(offset)); 
   uv -= offset; 
   uv *= rotate2d(iTime*0.05);
   float a = atan(uv.y,uv.x);
   float r = length(uv);
   float f = rad*cos(n*a);
   float blur = 0.0001;
   //return mix(mix(col1,col2,r),col,smoothstep(f-blur,f+blur,r));
   return mix(mix(col1,col2,r),col,smoothstep(-1.5,0.,(r-f) / fwidth(r-f)));
   
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    
    vec2 uv = fragCoord/iResolution.xy -0.5;
    
    uv.x *= iResolution.x/iResolution.y;
 
    uv *= 5.0; 
 
    uv = distort(uv,1.);
 
    vec3 col = mix(COLORS[3],COLORS[2],uv.y);
    
    
    for(float x = -len;x <= len;x+=1.)
    {
      for(float y = -len;y <= len;y+=1.)
      {
        vec2 pos = vec2(x,y) + 0.5;

        float rang  = 2.0*PI*(Hash21(pos*678.));
        float radFlower = floor(Hash21(pos*945.)*2. + 0.5);
        float dir = sign(0.5 - Hash21(pos*145.));
        uv *= rotate2d(rang*dir*iTime*0.01);
        col = drawFlower(uv,pos,radFlower,col,getColor(pos,567.),getColor(pos,145.));
        
      }
    } 
   
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

